unit Unitsettings;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, unitSerial;

type
  TFormSettings = class(TForm)
    BtnOk: TButton;
    BtnCancel: TButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    CBBaud: TComboBox;
    CBBits: TComboBox;
    CBParity: TComboBox;
    CBStopbits: TComboBox;
    GroupBox2: TGroupBox;
    CBXOn: TCheckBox;
    RBHW: TRadioButton;
    RBToggle: TRadioButton;
    RBNone: TRadioButton;
    BtnDefault: TButton;
    Label5: TLabel;
    LBPort: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure BtnDefaultClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

uses UnitTerm;

{$R *.xfm}

//-------------------------------------------------------------------------
// FormCreate
//-------------------------------------------------------------------------
// Function
//    fill dialgue with appropriate values
// Parameters
//    Sender - mandatory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormSettings.FormCreate(Sender: TObject);
var
   bauds:array of integer;
   i, n : integer;
begin

   // get max number of bauds that can be supported
   setlength(bauds, 0 );
   n := GetSupportedBauds( bauds );
   // set up an array to hold them
   setlength(bauds, n);
   // fill the array
   GetSupportedBauds( bauds );

   // if not an amlplicon card limit to 115200 baud
   if not FormTerm.Amplicon1.Checked Then
   begin
      n := 0;
      for i := 0 to high( bauds ) do
      begin
         if bauds[ i ]  <= 115200 then n := i;
      end;
   end
   else
      n :=  high( bauds );

   CBBaud.Items.Clear;
   
   for i := 0 to n do
   begin
        CBBaud.items.Add(inttostr(bauds[i]));
   end;
   setlength(bauds, 0);

   // now set up users settings
   // baud rate
   i := CBBaud.Items.IndexOf(InttoStr(FormTerm.UsercomParms.baud));

   if i > -1 then
        CBBaud.ItemIndex := i
   else
   begin
        i := CBBaud.Items.IndexOf('9600');
        if i > -1 then
           CBBaud.ItemIndex := i
        else
           CBBaud.ItemIndex := CBBaud.Items.Count -1;
   end;

   // DATA BITS
   i := CBBits.Items.IndexOf(InttoStr(FormTerm.UsercomParms.bits));
   if i > -1 then
        CBBits.ItemIndex := i
   else
        CBBits.ItemIndex := CBBits.Items.Count -1;;

   // STOP BITS
   i := CBStopBits.Items.IndexOf(InttoStr(FormTerm.UsercomParms.stopbits));
   if i > -1 then
        CBStopBits.ItemIndex := i
   else
        CBStopBits.ItemIndex := 0;

   // Parity
   i := CBParity.Items.IndexOf(FormTerm.UsercomParms.parity);
   if i > -1 then
        CBParity.ItemIndex := i
   else
        CBParity.ItemIndex := 2; // none

   // flow control
   if Formterm.UsercomParms.fswflow Then
        CBXon.Checked := true
   else
        CBXon.Checked := false;

   if Formterm.UsercomParms.fhwflow Then
   begin
        RBHW.Checked := True
   end     
   else
   begin
        RBNone.Checked := True;
   end;

   // half duplex stuff
   if FormTerm.UsercomParms.fAmplicon Then
   begin
      case  FormTerm.UsercomParms.halfDup of
      aNotSupported:
         begin
            RBToggle.Enabled := false;
            RBToggle.Checked := false;
         end;
      aHALFDUPLEX, aSLAVEMULTIPLEX : 
         begin
            RBToggle.Enabled := True;
            RBToggle.Checked := true;
         end
      else
      begin
         RBToggle.Enabled := True;
         RBToggle.Checked := false;
      end;                    
      end; // case
   end
   else
   begin
      RBToggle.Enabled := false;
      RBToggle.Checked := false;
   end;   

end;

//-------------------------------------------------------------------------
// BtnDefaultClick
//-------------------------------------------------------------------------
// Function
//    fill dialgue with appropriate values
// Parameters
//    Sender - mandatory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormSettings.BtnDefaultClick(Sender: TObject);
var
  i:integer;
begin
   // set up default settings
   i := CBBaud.Items.IndexOf('9600');
   if i > -1 then
       CBBaud.ItemIndex := i
   else
       CBBaud.ItemIndex := CBBaud.Items.Count -1;
   CBBits.ItemIndex := CBBits.Items.Count -1;;
   CBStopBits.ItemIndex := 0;
   CBParity.ItemIndex := 2; // none
   CBXon.Checked := false;
   RBNone.Checked := True;

end;

end.
