//
// Amplicon NT DIO Driver
//
// $Id$
//
// Copyright (c) 1996-1997
// by MEV Limited, 33 Willis Road, Cale Green, Stockport, SK3 8HQ
// +44 161 477 1898
// mev-ltd.demon.co.uk
//
// This source code is supplied as an example of TCsetUserInterrupt
// It may be freely re-used and modified, providing 
// relevant copyright is retained by MEV. Although the best endevours have 
// been made to ensure the accuracy of this code, MEV make no 
// warranty of any kind with regard to this sample source code.
//
// All rights reserved.
// Started 31 October 1996
//
// MODULE CONTENTS
//
// PPI timer example
//
// DESCRIPTION
//
// Example program that uses timer interrupt to poll port A of PPI
//
// ENVIRONMENT 
//
// Compiler:      Microsoft Visual C++ V4.0
// Target System: PC, running MS-Windows NT v4.0
//
// AMENDMENT RECORD
//
// $Log$
//
//
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "adioctl.h"
#include "dio_tc.h"

void CALLBACK TCProcessEvent(const short h, const short wParam, const ULONG Data)
{
   printf("\n\rAddress = %x had %x PPI on port X", wParam, Data);
   return;
}


void printusage(void)
{
	printf("\n\r\n\rUsage = PPIIRQ <BoardType> <address> <irq>");
	printf("\n\r\n\rwhere:");
	printf("\n\r\tBoardType = 212,214,215,218 or 272");
	printf("\n\r\taddress = base address (in Hex) eg 0x300");
	printf("\n\r\tirq = irq vector");
	printf("\n\r\neg:\n\r\tppiirq 214 300 5\n\r\n\rtests a PC214E card installed at 0x300 on IRQ 5\n\r");
}

void main(int argc, LPSTR argv[])
{
	short	hBoard;
	int cardtype, address, irq;
	short ret, hTCINT;
	ULONG i;
	
	printf("\n\rPPIIRQ is a quick console application to demonstrate");
	printf("\n\rreading the PPI registers on interrupt from an Amplicon");
	printf("\n\rDIO CT card.\n\r");

	if(argc != 4)
	{
		printusage();
		return;
	}

	cardtype = atoi(argv[1]);
	sscanf(argv[2], "%x", &address);
	irq = atoi(argv[3]);

	hBoard = registerBoard((short)cardtype, (short)address, (short)irq);

	if (hBoard < 0)
	{
		printf("\n\rUnable to find Amplicon PC%dE DIO CT card at", cardtype);
		printf(" address %x irq %d", address, irq);
		return;
	}

	ret = TCgenerateFreq(hBoard, Z1, 1, (float)10.0);	// irq 10 times a second

	if(ret != OK)
	{
		printf("\n\r Can't find counter timer Z1");
		return;
	}

	//
	// Set up PPI ports as outputs so we can tweek them
	//
	DIOsetMode(hBoard, PPIX, PORTA, FALSE);
	DIOsetMode(hBoard, PPIX, PORTB, FALSE);
	DIOsetMode(hBoard, PPIX, PORTC_U, FALSE);
	DIOsetMode(hBoard, PPIX, PORTC_L, FALSE);

	// 3 times 8 bit channels
	//
	DIOsetChanWidth(hBoard, PPIX, 24);

	hTCINT = TCsetUserInterrupt( hBoard
                                 , &TCProcessEvent
                                 , (short)address			// user param passed to user fn as wParam
                                 , Z1				// IRQ on Z1 timer
                                 , ISR_READ_PPIABC	// read PPI Port X
                                 , PPIX
                                 , 1
                                 , 0
                                 , 0
                                 );

	if(hTCINT < 0)
	{
		printf("\n\r Can't start timer IRQ");
		return;
	}

	printf("\n\rPress <return> to Stop");

	enableInterrupts( hBoard );

	i = 0;
	while(!_kbhit())
	{
		DIOsetData(hBoard, PPIX, 0, i++);
	}

	disableInterrupts( hBoard );
    TCfreeUserInterrupt(hBoard, hTCINT);
	FreeBoard(hBoard);
}
