//
// Amplicon NT DIO Driver
//
// $Id$
//
// Copyright (c) 1996-1997
// by MEV Limited, 33 Willis Road, Cale Green, Stockport, SK3 8HQ
// +44 161 477 1898
// mev-ltd.demon.co.uk
//
// All rights reserved.
// Started 31 October 1996
//
// MODULE CONTENTS
//
// adioctl.h      Include file for Amplicon DIO Port Driver
//                that defines the IOCTL interface 
//
// DESCRIPTION
//
// Define the IOCTL codes we will use.  The IOCTL code contains a command
// identifier, plus other information about the device, the type of access
// with which the file must have been opened, and the type of buffering.
//
// ENVIRONMENT 
//
//                Windows NT 4.0 SDK
//                Windows NT 4.0 DDK
//                SetEnv <DDKROOT>
// Compiler:      Microsoft Visual C++ V4.0
// Target System: PC, running MS-Windows NT v4.0
//
// AMENDMENT RECORD
//
// $Log$
//
//

//
// Amplicon Series 200 DIO driver card specific defines 
//

//
// Board types supported
//
#define NUMBER_CARDTYPES_SUPPORTED  5   

#define DIO_PC218E        0 // 6 CT blocks
#define DIO_PC212E        1 // 4 CT and 1 PPI
#define DIO_PC215E        2 // 2 CT and 2 PPI
#define DIO_PC214E        3 // 1 CT and 2 PPI
#define DIO_PC272E        4 // 3 PPI

//
// Max number of cards that can be installed in one system
//
#define NUMBER_CARD_SUPPORTED       8   

//
// total num IO blocks including clock, gate and interrupt
//
#define NUMBER_IO_BLOCKS_SUPPORTED  8   

//
// max num of CT or PPI blocks 
//
#define NUMBER_CT_DIO               6   

//
// Types of IO Block
//
#define NA             -1      // unused
#define CT              0      // counter timer 82C54
#define PPI             1      // PPI uPD71055
#define CTC             2      // Counter Timer Connections
#define IE              3      // interrupt enable

//
// Internal configuration information for DIO/CT cards
//
#define NUM214IRQEVENTS 5      // Num IRQ events supported on PC214E
#define NUMIRQEVENTS    6      // Num IRQ events on other cards

//
// Define masks that determine which bits of the interrupt enable
// are valid for the card, note PC214E only has 5 events, where as
// others have 6
//
#define VALIDEVENTMASK214   ((2<<NUM214IRQEVENTS)-1)
#define VALIDEVENTMASK      ((2<<NUMIRQEVENTS)-1)

#define IOBLKSIZE       4      // size of each CT/PPI IO Block
#define CTRLPORT        3      // offset of control port in IO block
#define MAXCHANNELS     3      // max number of data channels per IO block

#define CTC_CLK_BLOCK   6      // Clock source block number
#define CTC_GAT_BLOCK   6      // Gate source block number
#define IE_BLOCK        7      // Interrupt enable block number


//
// Device type           -- in the "User Defined" range."
//
#define DIO_TYPE 40000

//
// The IOCTL function codes from 0x800 to 0xFFF are for customer use.
//
#define IOCTL_QUERY_RESOURCE       \
   CTL_CODE( DIO_TYPE,  0x900, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_GET_DEVICE       \
   CTL_CODE( DIO_TYPE,  0x940, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_GET_NEXT_DEVICE       \
   CTL_CODE( DIO_TYPE,  0x941, METHOD_BUFFERED, FILE_READ_ACCESS )

//
// IRQ setup
//
#define IOCTL_ENABLE_IRQEVENT      \
   CTL_CODE( DIO_TYPE,  0x901, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_DISABLE_IRQEVENT     \
   CTL_CODE( DIO_TYPE,  0x902, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_GET_INTSTATUS   \
   CTL_CODE( DIO_TYPE,  0x903, METHOD_BUFFERED, FILE_READ_ACCESS )

//
// IRQ processing
//
#define IOCTL_WAIT_INTEVENT \
   CTL_CODE(DIO_TYPE,  0x904, METHOD_BUFFERED, FILE_READ_ACCESS | FILE_WRITE_ACCESS)

//
// Port IO
//
#define IOCTL_SET_CTDATA     \
   CTL_CODE( DIO_TYPE,  0x920, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_GET_CTDATA     \
   CTL_CODE( DIO_TYPE, 0x921, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_SET_CTCONTROL  \
   CTL_CODE( DIO_TYPE,  0x922, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_SET_CTCLK      \
   CTL_CODE( DIO_TYPE, 0x924, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_SET_CTGATE     \
   CTL_CODE( DIO_TYPE, 0x925, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_SET_PPIDATA    \
   CTL_CODE( DIO_TYPE,  0x930, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_GET_PPIDATA    \
   CTL_CODE( DIO_TYPE, 0x931, METHOD_BUFFERED, FILE_READ_ACCESS )

#define IOCTL_SET_PPICONTROL \
   CTL_CODE( DIO_TYPE,  0x932, METHOD_BUFFERED, FILE_WRITE_ACCESS )

#define IOCTL_GET_PPISTATUS  \
   CTL_CODE( DIO_TYPE,  0x933, METHOD_BUFFERED, FILE_READ_ACCESS )

//
// A union to make extracting the byte data from the IOCTL buffer
// simplier 
//
typedef union _TLONGUNION
{
   ULONG   DataWord;
   UCHAR   DataByte[4];
}TLONGUNION;

//
// sub - structure used to communicate with IOCTL query
// resource IOCTL call that resturns card configuration
// according to AMPDIO Control Panel Applet settings
//
typedef struct _DIO_PORTRESOURCE
{
   UCHAR    PortType;     
   UCHAR    PortIRQ;
   short    PortBase;
}DIO_PORTRESOURCE;

//
// A union for the data buffer so we can access it as byte, word
// or resource information depending on what IOCTL we called
//
typedef union _TPORTDIOUNION
{
   ULONG   DataWord;
   UCHAR   DataByte[4];
   DIO_PORTRESOURCE Resource;
}TPORTDIOUNION;

//
// Structure used to communicate with IOCTL read and write IO port
//
typedef struct  _TDIO_PORTIO 
{
   ULONG   BlockNumber;        // Group 0 to NUMBER_IO_BLOCKS_SUPPORTED
   ULONG   PortNumber;         // Port # to write to 0 to MAXCHANNELS
   TPORTDIOUNION u;            // Data
} TDIO_PORTIO, * PTDIO_PORTIO;

//
// Structure used to communicate with IOCTL enable interrupt call
// Configures what data to fetch to IOWaitIRQEvent when interrupt
// occurs
//
#define ISR_NODATA        -1   // no data needed
#define ISR_READ_16COUNT  0    // reads a timer counter channel
#define ISR_READ_32COUNT  1    // reads two chained counters
#define ISR_READ_PPIABC   5    // reads data from all 3 PPI ports

typedef struct _TDIO_IRQSETUP {
   ULONG   EventNumber;        // IRQ event 0 to 5
   ULONG   DataRequired;       // Type of data to fetch

   ULONG   BlockNumber1;       // Group X,Y or Z of first port
   ULONG   PortNumber1;        // Port # to write to
   ULONG   BlockNumber2;       // Group X,Y or Z of 2nd port
   ULONG   PortNumber2;        // Port # to write to
} TDIO_IRQSETUP, * PTDIO_IRQSETUP;

