//
// DIO_TC Interface
//
// $Id$
//
// MODULE CONTENTS
//
// DIO_TC and IOCTL Interface for Amplicon Digital IO driver
//
// COPYRIGHT
//
// This source code is supplied as an example of interfacing 
// with an Amplicon PC24 DAC counter timer card in Delphi 3.0
// It may be freely re-used and modified, providing 
// relevant copyright is retained by MEV. Although the best endevours have 
// been made to ensure the accuracy of this code, MEV make no 
// warranty of any kind with regard to this sample source code.
//
// by MEV Ltd
// Copyright (c) 1997 MEV Limited
// Suite 4 Baxall Business Centre, Unit 25b,
// Adswood Road Ind Est, STOCKPORT, Cheshire. SK3 8LF
// +44 (0)161 477 1898
// @mev-ltd.demon.co.uk
//
// ENVIRONMENT
//    Compiler:      Borland Delphi 3 ( 32 Bit )
//    Target system: PC, running MS-Windows NT
//
// AMENDMENT RECORD
//
// $Log$
// Start   1.00  18/12/97
//
unit AmpComm;

interface
uses
  Windows;
Const

{ Boards supported...  }
  PC212E     = 212;
  PC214E     = 214;
  PC215E     = 215;
  PC218E     = 218;
  PC272E     = 272;
  PC36AT     = 36;
  PC263      = 263;
  PC24       = 24;
  PC27       = 27;
                
{  PC226E     = 226;
   PC30AT     = 30;
   PC26AT     = 26;

{ Group base address offsets... }
  PPIX       = 0;                    { PPI X    }
  PPIY       = 8;                    { PPI Y    }
  PPIZ       = 16;                   { PPI Z    }
  X1         = 0;                    { Timer X1 }
  X2         = 4;                    { Timer X2 }
  Y1         = 8;                    { Timer Y1 }
  Y2         = 12;                   { Timer Y2 }
  Z1         = 16;                   { Timer Z1 }
  Z2         = 20;                   { Timer Z2 }

{ PPI ports for setting mode... }
  PORTA      = 0;
  PORTB      = 1;
  PORTC_L    = 2;
  PORTC_H    = 3;

  CHAN_0     = 0;
  CHAN_1     = 1;
  CHAN_2     = 2;

  OUTPUT     = 0;
  INPUT      = 1;

{ Timer counter clock sources...}
  CLK_CLK    = 0;
  CLK_10MHZ  = 1;
  CLK_1MHZ   = 2;
  CLK_100KHZ = 3;
  CLK_10KHZ  = 4;
  CLK_1KHZ   = 5;
  CLK_OUTN_1 = 6;
  CLK_EXT    = 7;

{ Timer counter gate sources... }
  GAT_VCC    = 0;
  GAT_GND    = 1;
  GAT_EXT    = 2;
  GAT_OUTN_2 = 3;

{ Error codes...                }
  OK         =  0;
  ERRSUPPORT = -1;
  ERRBASE    = -2;
  ERRIRQ     = -3;
  ERRHANDLE  = -4;
  ERRCHAN    = -5;
  ERRDATA    = -6;
  ERRRANGE   = -7;
  ERRMEMORY  = -8;
  ERRBUFFER  = -9;
  ERRPC226   = -10;

  // IOCTL CODES 

  METHOD_BUFFERED = 0;
  METHOD_IN_DIRECT = 1;
  METHOD_OUT_DIRECT = 2;
  METHOD_NEITHER = 3;

  FILE_ANY_ACCESS = 0;
  FILE_READ_ACCESS = 1;
  FILE_WRITE_ACCESS = 2;
  IOCTL_QUERY_RESOURCE = (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($900 shl 2 ) or METHOD_BUFFERED ;

  IOCTL_ENABLE_IRQEVENT = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($901 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_DISABLE_IRQEVENT = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($902 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_GET_INTSTATUS_CHAR = (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($903 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_WAIT_INTEVENT = (40000 shl 16) or ((FILE_WRITE_ACCESS or FILE_READ_ACCESS)shl 14) or ($904 shl 2 ) or METHOD_BUFFERED ;

  IOCTL_SET_CTDATA_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($920 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_GET_CTDATA_UCHAR = (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($921 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_SET_CTCONTROL_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($922 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_SET_CTCLK_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($924 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_SET_CTGATE_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($925 shl 2 ) or METHOD_BUFFERED ;

  IOCTL_SET_PPIDATA_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($930 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_GET_PPIDATA_UCHAR = (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($931 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_SET_PPICONTROL_UCHAR = (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($932 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_GET_PPISTATUS_UCHAR = (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($933 shl 2 ) or METHOD_BUFFERED ;

  IOCTL_GET_IODATA =  (40000 shl 16) or (FILE_READ_ACCESS shl 14) or ($934 shl 2 ) or METHOD_BUFFERED ;
  IOCTL_SET_IODATA =  (40000 shl 16) or (FILE_WRITE_ACCESS shl 14) or ($935 shl 2 ) or METHOD_BUFFERED ;

  // IOCTL CODES used in TCsetUserInterrupt
  
  ISR_NODATA  = -1;       // no data needed
  ISR_READ_16COUNT = 0;    // reads a timer counter channel
  ISR_READ_32COUNT = 1;    // reads two chained counters
  ISR_READ_PPIABC =  5;    // reads data from all 3 PPI ports
  ISR_READ_PPISTATUS =  6;   // reads PPISTATUS 
  ISR_READ_PPIM1READ =  7;   // reads the data from PPI port if available

{ DIO_TC.DLL Functions }
{------------------------------------------------------------------------------}
{ Initialisation Functions }
{------------------------------------------------------------------------------}
Function registerBoardEx( no: smallint ): smallint; stdcall;
Function registerBoard( model, ba, irq: smallint ): smallint; stdcall;
Function GetBoardModel( h: smallint ): smallint; stdcall;
Function FreeBoard( h: smallint ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Interrupt Control Functions }
{------------------------------------------------------------------------------}
Function setIntMask( h, mask: smallInt ): smallint; stdcall;
Function getIntStat( h: smallint ): smallint; stdcall;
Function enableInterrupts( h: SmallInt ): SmallInt; stdcall;
Function disableInterrupts( h: SmallInt ): SmallInt; stdcall;
{------------------------------------------------------------------------------}
{ Data Buffer Functions }
{------------------------------------------------------------------------------}
Function allocateIntegerBuf( nItems: LongInt ): smallint; stdcall;
Function allocateLongBuf( nItems: LongInt ): smallint; stdcall;
Function freeIntegerBuf( hiB: SmallInt ): smallint; stdcall;
Function freeLongBuf( hlB: SmallInt ): smallint; stdcall;
Function readIntegerBuf( hiB: SmallInt; item: LongInt; p: Pointer ): smallint; stdcall;
Function readLongBuf( hlB: SmallInt; item: LongInt; p: Pointer ): smallint; stdcall;
Function writeIntegerBuf( hiB: SmallInt; item: LongInt; dat: WORD ): smallint; stdcall;
Function writeLongBuf( hlB: SmallInt; item, dat: LongInt ): smallint; stdcall;
Function copyToIntegerBuf( hiB: SmallInt; start, nItems: LongInt; p: Pointer ): smallint; stdcall;
Function copyToLongBuf( hlB: SmallInt; start, nItems: LongInt; p: Pointer ): smallint; stdcall;
Function copyFromIntegerBuf( hiB: SmallInt; start, nItems: LongInt; p: Pointer ): smallint; stdcall;
Function copyFromLongBuf( hlB: SmallInt; start, nItems: LongInt; p: Pointer ): smallint; stdcall;
Function getLongIntItem(hlB: SmallInt; item: Pointer ): smallint; stdcall;
{Function getSmallIntIntItem( hiB: SmallInt; item: Pointer ): smallint; stdcall;  external 'DIO_TC.DLL';}
{------------------------------------------------------------------------------}
{ Timer / Counter Functions }
{------------------------------------------------------------------------------}
Function TCisAvailable( h, chip, chan: SmallInt  ): smallint; stdcall;
Function TCfreeResource( h, chip, chan: SmallInt  ): smallint; stdcall;
Function TCsetClock( h, chip, chan, clk: SmallInt ): smallint; stdcall;
Function TCsetGate( h, chip, chan, gat: SmallInt ): smallint; stdcall;
Function TCsetMode( h, chip, chan, mde: SmallInt ): smallint; stdcall;
Function TCgetStatus( h, chip, chan: SmallInt  ): smallint; stdcall;
Function TCsetCount( h, chip, chan: SmallInt; count: LongInt ): smallint; stdcall;
Function TCgetCount( h, chip, chan: SmallInt; count: Pointer ): smallint; stdcall;
Function TCgetUpCount( h, chip, chan: SmallInt; count: Pointer ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Differential Counter Functions }
{------------------------------------------------------------------------------}
Function TCsetDiffCounters( h, chip1, chan1, clk1, gat1, chip2, chan2, clk2, gat2: SmallInt ): SmallInt; stdcall;                                                                              {  80 } Function TCgetDiffCount( h, hD: SmallInt; diff: Pointer ): smallint; stdcall;
Function TCgetRatio( h, hD: SmallInt; ratio: Pointer ): smallint; stdcall;
Function TCfreeDiffCounters( h, hD: SmallInt ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Frequency Generation Functions }
{------------------------------------------------------------------------------}
Function TCsetMonoShot( h, chip, chan: SmallInt; duration: Single ): smallint; stdcall;
Function TCsetAstable(  h, chip, chan, chipS, chanS: SmallInt; freq, msratio: Single ): SmallInt; stdcall;
Function TCfreeAstable( h, hA: SmallInt ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Millisecond Stopwatch Functions }
{------------------------------------------------------------------------------}
Function TCsetStopwatch( h, chip, chan: SmallInt ): smallint; stdcall;
Function TCstartStopwatch( h, hS: SmallInt ): smallint; stdcall;
Function TCgetElapsedTime( h, hS: SmallInt; lPtr: Pointer ): smallint; stdcall;
Function TCsetEventRecorder( h, hS, chip, hlB: SmallInt ): smallint; stdcall;
Function TCfreeEventRecorder( h, hE: SmallInt ): smallint; stdcall;
Function TCgetTimeStr( ms: LongInt; strPtr: Pointer ): smallint; stdcall;
Function TCfreeStopwatch( h, hS: SmallInt ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Frequency Input & Output Functions }
{------------------------------------------------------------------------------}
Function TCgetExtPeriod( h, chip, chan: SmallInt; fPtr: Pointer ): smallint; stdcall;
Function TCgetExtFreq( h, chip, chan: SmallInt; fPtr: Pointer  ): smallint; stdcall;
Function TCgenerateFreq( h, chip, chan: SmallInt; freq: Single ): smallint; stdcall;
Function TCgenerateAccFreq( h, chip, chan: SmallInt; freq: Single ): smallint; stdcall;
Function TCmultiplyFreq( h, ipChip, ipChan, opChip, opChan: SmallInt; factor: Single  ): SmallInt; stdcall ;
Function TCdivideFreq( h, ipChip, ipChan, opChip, opChan: SmallInt; divisor: Single ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Digitally & Voltage Controlled Oscillator Funtions }
{------------------------------------------------------------------------------}
Function TCsetDCO( h, diChip, diChan, opChip, opChan: SmallInt; udFreq: Single; udChip: SmallInt; MinF, MaxF: Single ):
SmallInt; stdcall;
Function TCsetUserCO( h:smallint;pfn: pointer ; opChip, opChan: SmallInt; udFreq: Single; udChip: SmallInt; MinF, MaxF: Single ):
SmallInt; stdcall;
Function TCsetUserCOLevel(h, hCO:smallint; Value:longint): SmallInt;  stdcall;
 Function TCfreeDCO( h, hO: SmallInt ): smallint; stdcall;

{------------------------------------------------------------------------------}
{ User interrupt
{------------------------------------------------------------------------------}
Function TCsetUserInterrupt(h:smallint; pfn:pointer; wParam:WPARAM; chip, ISRDATA, chip1, chan1, chip2, chan2:Smallint): smallint; stdcall;
Function TCfreeUserInterrupt (h, hUserInt:smallint): smallint; stdcall;

{------------------------------------------------------------------------------}
{ Digital Input / Output Functions }
{------------------------------------------------------------------------------}
 Function DIOisAvailable( h, chip: SmallInt ): smallint; stdcall;
 Function DIOsetMode( h, chip, chan, isInput: SmallInt ): smallint; stdcall;
 Function DIOsetChanWidth ( h, chip, numBits: SmallInt ): smallint; stdcall;
 Function DIOsetData( h, chip, chan: SmallInt; dat: LongInt ): smallint; stdcall;
 Function DIOgetData( h, chip, chan: SmallInt; dat: Pointer ): smallint; stdcall;
{------------------------------------------------------------------------------}
{ Switch Scanner Matrix Functions }
{------------------------------------------------------------------------------}
Function DIOsetSwitchMatrix( h, order: SmallInt ): smallint; stdcall;
Function DIOgetSwitchStatus( h, xcoord, ycoord: SmallInt ): smallint; stdcall;
Function DIOfreeSwitchMatrix( h: SmallInt ): smallint; stdcall;

{------------------------------------------------------------------------------}
{ New low and dirty DIO functions
{------------------------------------------------------------------------------}
Function DIO_TC_IOCTL( h:smallint; code:DWORD; pIOBuffer:pointer;BufferSize:DWORD):smallint; stdcall;
Function DIOsetDataEx(h, chip, chan, data:smallint): smallint; stdcall;
Function DIOgetDataEx(h, chip,  chan:smallint; var data:integer): smallint; stdcall;
Function DIOsetModeEx(h, chip,  data:smallint): smallint; stdcall;

{------------------------------------------------------------------------------}
{ Analogue IO
{------------------------------------------------------------------------------}
Function PC27SetMultiplexer( h, data:Smallint): smallint; stdcall;
Function PC27StartConversion( h:Smallint): smallint; stdcall;
Function PC27getData( h, chan:Smallint; var data:Smallint): smallint; stdcall;
Function PC24setData( h, chan, data:Smallint): smallint; stdcall;

  
implementation
{ DIO_TC.DLL Functions }
{------------------------------------------------------------------------------}
{ Initialisation Functions }
{------------------------------------------------------------------------------}
Function registerBoardEx( no: smallint ): smallint; stdcall; external 'DIO_TC.dll';
Function registerBoard( model, ba, irq: smallint ): smallint; stdcall; external 'DIO_TC.dll';
Function GetBoardModel( h: smallint ): smallint; stdcall; external 'DIO_TC.dll';
Function FreeBoard( h: smallint ): smallint; stdcall; external 'DIO_TC.dll';
{------------------------------------------------------------------------------}
{ Interrupt Control Functions }
{------------------------------------------------------------------------------}
Function setIntMask( h, mask: smallint ): smallint; far; stdcall ; external 'DIO_TC.DLL';
Function getIntStat( h: smallint ): smallint; far; stdcall ; external 'DIO_TC.DLL';
Function enableInterrupts( h: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function disableInterrupts( h: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Data Buffer Functions }
{------------------------------------------------------------------------------}
Function allocateIntegerBuf( nItems: LongInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function allocateLongBuf( nItems: LongInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function freeIntegerBuf( hiB: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function freeLongBuf( hlB: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function readIntegerBuf( hiB: SmallInt; item: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function readLongBuf( hlB: SmallInt; item: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function writeIntegerBuf( hiB: SmallInt; item: LongInt; dat: WORD ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function writeLongBuf( hlB: SmallInt; item, dat: LongInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function copyToIntegerBuf( hiB: SmallInt; start, nItems: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function copyToLongBuf( hlB: SmallInt; start, nItems: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function copyFromIntegerBuf( hiB: SmallInt; start, nItems: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function copyFromLongBuf( hlB: SmallInt; start, nItems: LongInt; p: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function getLongIntItem(hlB: SmallInt; item: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
{ Function getSmallIntIntItem( hiB: SmallInt; item: Pointer ): SmallInt;  external 'DIO_TC.DLL';}
{------------------------------------------------------------------------------}
{ Timer / Counter Functions }
{------------------------------------------------------------------------------}
Function TCisAvailable( h, chip, chan: SmallInt  ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCfreeResource( h, chip, chan: SmallInt  ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCsetClock( h, chip, chan, clk: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function TCsetGate( h, chip, chan, gat: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function TCsetMode( h, chip, chan, mde: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function TCgetStatus( h, chip, chan: SmallInt  ): SmallInt;  external 'DIO_TC.DLL';
Function TCsetCount( h, chip, chan: SmallInt; count: LongInt ): SmallInt;  external 'DIO_TC.DLL';
Function TCgetCount( h, chip, chan: SmallInt; count: Pointer ): SmallInt;  external 'DIO_TC.DLL';
Function TCgetUpCount( h, chip, chan: SmallInt; count: Pointer ): SmallInt;  external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Differential Counter Functions }
{------------------------------------------------------------------------------}
 Function TCsetDiffCounters( h, chip1, chan1, clk1, gat1, chip2, chan2, clk2, gat2: SmallInt ):
           SmallInt;  external 'DIO_TC.DLL';
 Function TCgetDiffCount( h, hD: SmallInt; diff: Pointer ): SmallInt;  external 'DIO_TC.DLL';
 Function TCgetRatio( h, hD: SmallInt; ratio: Pointer ): SmallInt;  external 'DIO_TC.DLL';
 Function TCfreeDiffCounters( h, hD: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Frequency Generation Functions }
{------------------------------------------------------------------------------}
Function TCsetMonoShot( h, chip, chan: SmallInt; duration: Single ): SmallInt;  external 'DIO_TC.DLL';
Function TCsetAstable(  h, chip, chan, chipS, chanS: SmallInt; freq, msratio: Single ):
         SmallInt;  external 'DIO_TC.DLL';
Function TCfreeAstable( h, hA: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Millisecond Stopwatch Functions }
{------------------------------------------------------------------------------}
Function TCsetStopwatch( h, chip, chan: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCstartStopwatch( h, hS: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCgetElapsedTime( h, hS: SmallInt; lPtr: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCsetEventRecorder( h, hS, chip, hlB: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCfreeEventRecorder( h, hE: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCgetTimeStr( ms: LongInt; strPtr: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCfreeStopwatch( h, hS: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Frequency Input & Output Functions }
{------------------------------------------------------------------------------}
Function TCgetExtPeriod( h, chip, chan: SmallInt; fPtr: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCgetExtFreq( h, chip, chan: SmallInt; fPtr: Pointer  ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCgenerateFreq( h, chip, chan: SmallInt; freq: Single ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCgenerateAccFreq( h, chip, chan: SmallInt; freq: Single ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCmultiplyFreq( h, ipChip, ipChan, opChip, opChan: SmallInt; factor: Single  ):
         SmallInt; stdcall ; external 'DIO_TC.DLL';
Function TCdivideFreq( h, ipChip, ipChan, opChip, opChan: SmallInt; divisor: Single ): SmallInt; stdcall ; external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Digitally & Voltage Controlled Oscillator Funtions }
{------------------------------------------------------------------------------}
Function TCsetDCO( h, diChip, diChan, opChip, opChan: SmallInt; udFreq: Single; udChip: SmallInt; MinF, MaxF: Single ):
         SmallInt; external 'DIO_TC.DLL';
Function TCsetUserCO( h:smallint;pfn: pointer ; opChip, opChan: SmallInt; udFreq: Single; udChip: SmallInt; MinF, MaxF: Single ):
         SmallInt; external 'DIO_TC.DLL';
Function TCsetUserCOLevel(h, hCO:smallint; Value:longint): SmallInt;  external 'DIO_TC.DLL';
Function TCfreeDCO( h, hO: SmallInt ): SmallInt;  external 'DIO_TC.DLL';


{------------------------------------------------------------------------------}
{ User interrupt
{------------------------------------------------------------------------------}
Function TCsetUserInterrupt(h:smallint; pfn:pointer; wParam:WPARAM; chip, ISRDATA, chip1, chan1, chip2, chan2:Smallint): smallint;  external 'DIO_TC.DLL';
Function TCfreeUserInterrupt (h, hUserInt:smallint): smallint;  external 'DIO_TC.DLL';


{------------------------------------------------------------------------------}
{ Digital Input / Output Functions }
{------------------------------------------------------------------------------}
Function DIOisAvailable( h, chip: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function DIOsetMode( h, chip, chan, isInput: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function DIOsetChanWidth ( h, chip, numBits: SmallInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function DIOsetData( h, chip, chan: SmallInt; dat: LongInt ): SmallInt; stdcall ; external 'DIO_TC.DLL';
Function DIOgetData( h, chip, chan: SmallInt; dat: Pointer ): SmallInt; stdcall ; external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Switch Scanner Matrix Functions }
{------------------------------------------------------------------------------}
Function DIOsetSwitchMatrix( h, order: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function DIOgetSwitchStatus( h, xcoord, ycoord: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function DIOfreeSwitchMatrix( h: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
Function DIOfreeBiDirectionalBus( h, hI: SmallInt ): SmallInt;  external 'DIO_TC.DLL';
{------------------------------------------------------------------------------}
{ Low and dirty DIO calls
{------------------------------------------------------------------------------}
Function DIO_TC_IOCTL( h:smallint; code:DWORD; pIOBuffer:pointer; BufferSize:DWORD):smallint;  external 'DIO_TC.DLL';
Function DIOsetDataEx(h, chip, chan, data:smallint): smallint;  external 'DIO_TC.DLL';
Function DIOgetDataEx(h, chip,  chan:smallint; var data:integer): smallint;  external 'DIO_TC.DLL';
Function DIOsetModeEx(h, chip,  data:smallint): smallint;  external 'DIO_TC.DLL';

{------------------------------------------------------------------------------}
{ Analogue IO
{------------------------------------------------------------------------------}
Function PC27SetMultiplexer( h, data:Smallint): smallint; external 'DIO_TC.DLL';
Function PC27StartConversion( h:Smallint): smallint; external 'DIO_TC.DLL';
Function PC27getData( h, chan:Smallint; var data:Smallint): smallint; external 'DIO_TC.DLL';
Function PC24setData( h, chan, data:Smallint): smallint; external 'DIO_TC.DLL';

end.




