//
// MEV Terminal Program
//
// Version 1.01
//
// PROJECT DESCRIPTION
//
// Delphi 5 Comms Example using Win32 Comms I/F
//
// Reference documentation
//      Serial Communications in Win32 MSDN Library Jan 1997
//
// This source code is supplied as an example of a win32 communications
// in delphi 5. It may be freely re-used and modified, providing
// relevant copyright is retained by MEV. Although the best endevours have
// been made to ensure the accuracy of this code, MEV make no
// warranty of any kind with regard to this sample source code.
//
// by MEV Ltd
// Copyright (c) 1997-2000 MEV Limited
// Suite 4 Baxall Business Centre, Unit 25b,
// Adswood Road Ind Est, STOCKPORT, Cheshire. SK3 8LF
// +44 (0)161 477 1898
// @mev-ltd.demon.co.uk
//
// ENVIRONMENT
//    Compiler:      Borland Delphi 5 ( 32 Bit )
//    Target system: PC, running MS-Windows NT or Windows 95, 98
//
// AMENDMENT RECORD
//
// Start     1.00  14/05/1998
// Reworked  1.01  08/02/2000
//
// KNOWN LIMITATIONS / PROBLEMS
//
// Can't paste more that 64K into out going buffer
// A single line can't be more than 1024K
//

unit UnitTerm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ComCtrls, ToolWin, ExtCtrls, unitAbout, ImgList,
  lmdcctrl, lmdctrl, lmdeditb, lmdmemoc, LMDMemo;

type
  TUIState = (itNotConnected, itConnected, itDisConnected);

  TFormTerm = class(TForm)
    MainMenu1: TMainMenu;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    SelectAll1: TMenuItem;
    N1: TMenuItem;
    ClearBuffer1: TMenuItem;
    Transffers1: TMenuItem;
    Help1: TMenuItem;
    NewConnection1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    SendTextFile1: TMenuItem;
    ViewTextFile1: TMenuItem;
    Contents1: TMenuItem;
    Searchforhelpon1: TMenuItem;
    Howtousehelp1: TMenuItem;
    N4: TMenuItem;
    AboutMEVTerminal1: TMenuItem;
    N3: TMenuItem;
    Settings2: TMenuItem;
    Connect1: TMenuItem;
    Disconnect1: TMenuItem;
    ToolBar1: TToolBar;
    TBNewConnection: TToolButton;
    PopupComPorts: TPopupMenu;
    None1: TMenuItem;
    Com11: TMenuItem;
    Com21: TMenuItem;
    Com31: TMenuItem;
    Com41: TMenuItem;
    Com51: TMenuItem;
    Com61: TMenuItem;
    Com71: TMenuItem;
    Com81: TMenuItem;
    Other1: TMenuItem;
    ToolButton1: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton11: TToolButton;
    ImageList1: TImageList;
    TBConnect: TToolButton;
    TBDisconnect: TToolButton;
    TBSettings: TToolButton;
    TBCopy: TToolButton;
    TBPaste: TToolButton;
    TBSelectall: TToolButton;
    TBClearBuffer: TToolButton;
    Panel1: TPanel;
    PanelStatus: TPanel;
    Panel3: TPanel;
    PanelRxStatus: TPanel;
    PanelTxStatus: TPanel;
    Timer1: TTimer;
    Memo1: TRichEdit;
    N5: TMenuItem;
    Print1: TMenuItem;
    PrintDialog1: TPrintDialog;
    S1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Format1: TMenuItem;
    Font1: TMenuItem;
    FontDialog1: TFontDialog;
    Memo2: TRichEdit;
    OpenDialog1: TOpenDialog;
    procedure Exit1Click(Sender: TObject);
    procedure ClearBuffer1Click(Sender: TObject);
    procedure NewConnection1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Disconnect1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TBNewConnectionClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure Timer1Timer(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Settings2Click(Sender: TObject);
    procedure Connect1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure S1Click(Sender: TObject);
    procedure AboutMEVTerminal1Click(Sender: TObject);
    procedure Font1Click(Sender: TObject);
    procedure SendTextFile1Click(Sender: TObject);
    procedure ViewTextFile1Click(Sender: TObject);
  private
    { Private declarations }
    DevName: array [0..20] of char;     // device name
    CommConfig:TCommConfig;             // comms config structure
    hComm:Thandle;                      // comms handle

    BytesRxed : cardinal;              // byte counts
    BytesTxed : cardinal;
    RxBuffer: array [0..1023] of char; // TX / RX buffers
    TxBuffer: array [0..1023] of char;

    osRx:TOverLapped;                  // overlapped structures for comms
    osTx:TOverLapped;
    fTxing:Boolean;                    // flag saying we are transmitting
    fWaitingRx:boolean;                // flag saying we are waiting for rx data
    InTimer:Boolean;                   // re-entrancy flag for timer
    InPaste:Boolean;                   // re-entrancy flag for paste operations
    extra:string;                      // temp buffer for keypresses
    p:integer;                         // position in string for incomomg text

    function SetComProperties(ComName:string; var CommConfig:TCommConfig):Boolean;
    function Connect(ComName:string; CommConfig:TCommConfig):boolean;
    procedure SetUI(State : TUIState);
    function AreDisConnected:Boolean;
    procedure UpdateMemo(a : array of char; l : cardinal);
    procedure InitComms;
    procedure FreeComms;
  public
    { Public declarations }
  end;

var
  FormTerm: TFormTerm;

implementation

uses UnitConnect;

{$R *.DFM}

//-------------------------------------------------------------------------
// FormCreate
//-------------------------------------------------------------------------
// Function
//    Set up overlapped structures etc
// Parameters
//    Sender - mandatory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.FormCreate(Sender: TObject);
begin
    hComm :=  INVALID_HANDLE_VALUE;

    // zero byte counts
    BytesTxed := 0;
    BytesRxed := 0;

    // set up overlapped structures for comss
    osRx.Internal := 0;
    osRx.InternalHigh := 0;
    osRx.Offset := 0;
    osRx.OffsetHigh := 0;

    osRx.hEvent := INVALID_HANDLE_VALUE;

    osTx.Internal := 0;
    osTx.InternalHigh := 0;
    osTx.Offset := 0;
    osTx.OffsetHigh := 0;

    osTx.hEvent := INVALID_HANDLE_VALUE;

    // set up flags
    fTxing := false;
    fWaitingRx := false;
    SetUI(itNotConnected);

end;

//-------------------------------------------------------------------------
// Exit
//-------------------------------------------------------------------------
// Function
//    Close Program
// Parameters
//    Sender - manadory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.Exit1Click(Sender: TObject);
begin
  close;
end;

//-------------------------------------------------------------------------
// FormClose
//-------------------------------------------------------------------------
// Function
//    Called when Program closing, free handles if open
// Parameters
//    Sender - manadory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.FormClose(Sender: TObject; var Action: TCloseAction);
begin

   If Not AreDisConnected() Then
      Action := caNone
   else
   begin
      Timer1.Enabled := False;
   end;

   if hComm <> INVALID_HANDLE_VALUE Then CloseHandle(hComm);
   if osTx.hEvent <> INVALID_HANDLE_VALUE Then closeHandle(osRx.hEvent);
   if osTx.hEvent <> INVALID_HANDLE_VALUE Then closeHandle(osTx.hEvent);
end;


//-------------------------------------------------------------------------
// OPEN PORT / CLOSE PORT
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// InitComms
//-------------------------------------------------------------------------
// Function
//     Initialise coms, reset bytes rxed/rxed and overlapped structures
// Parameters
//     None
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.InitComms;
begin
    BytesTxed := 0;
    BytesRxed := 0;

    // overlapped structure for reciever
    osRx.Internal := 0;
    osRx.InternalHigh := 0;
    osRx.Offset := 0;
    osRx.OffsetHigh := 0;

    osRx.hEvent := CreateEvent(nil, TRUE, FALSE, nil);

    // overlapped structure for transmitter
    osTx.Internal := 0;
    osTx.InternalHigh := 0;
    osTx.Offset := 0;
    osTx.OffsetHigh := 0;

    osTx.hEvent := CreateEvent(nil, TRUE, FALSE, nil);

    // Flags for overlapped state
    fTxing := false;
    fWaitingRx := false;

    // position in incoming text buffer
    p := 1;

end;

//-------------------------------------------------------------------------
// FreeComms
//-------------------------------------------------------------------------
// Function
//     Release and reset handles
// Parameters
//     None
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.FreeComms;
begin
      if hComm <> INVALID_HANDLE_VALUE Then
      begin
          // release coms port
          CloseHandle(hComm);
          // release overlapped structure events
          if osTx.hEvent <> INVALID_HANDLE_VALUE Then closeHandle(osRx.hEvent);
          if osTx.hEvent <> INVALID_HANDLE_VALUE Then closeHandle(osTx.hEvent);
          // reset handles
          hComm := INVALID_HANDLE_VALUE;
          osTx.hEvent := INVALID_HANDLE_VALUE;
          osTx.hEvent := INVALID_HANDLE_VALUE;
      end;
      // if we are disconnected, tell the user about it
      if hComm = INVALID_HANDLE_VALUE Then  SetUI(itDisConnected);

end;

//-------------------------------------------------------------------------
// SetUI
//-------------------------------------------------------------------------
// Function
//     Sets User Interface depending on state connected or not connected
// Parameters
//     State : TUIState
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.SetUI(State : TUIState);
begin
     // sort buttons on UI out
     case State of
     itConnected :
     begin
          DisConnect1.Enabled := true;
          TBDisconnect.Enabled := true;
          Connect1.Enabled := False;
          TBConnect.Enabled := False;
          Settings2.Enabled := true;
          TBsettings.Enabled := true;
     end;

     // we have a connection but now its gone
     itDisConnected :
     begin
          DisConnect1.Enabled := False;
          TBDisconnect.Enabled := False;
          Connect1.Enabled := True;
          TBConnect.Enabled := True;
          Settings2.Enabled := true;
          TBsettings.Enabled := True;
     end;

     // we have never had a connection, so we can't change properties
     itNotConnected :
     begin
          DisConnect1.Enabled := False;
          TBDisconnect.Enabled := False;
          Connect1.Enabled := False;
          TBConnect.Enabled := False;
          Settings2.Enabled := False;
          TBsettings.Enabled := False;
     end;

     end; // case
end;

//-------------------------------------------------------------------------
// Connect
//-------------------------------------------------------------------------
// Function
//     Open the port and set up the port properties
// Parameters
//    ComName : Name of port
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
function TFormTerm.Connect(ComName:string; CommConfig:TCommConfig):Boolean;
var
  s:string;
  LDevName: array [0..20] of char;
  ComTimeOuts:TCOMMTIMEOUTS;
begin
   // If we already have a comm port open close it
   if hComm <>  INVALID_HANDLE_VALUE then
   begin
      Timer1.Enabled := False;
      freeComms();
   end;

   // make a com name of the form Com1:
   strPCopy(@devName, ComName);

   // make a device name, as we need a device name to open com9 and above
   s := '\\.\'+ComName;
   strPCopy(@LdevName, s);

   // Open the comm port;
   hComm := CreateFile( LDevName
               , GENERIC_READ or GENERIC_WRITE
               , 0
               , nil
               , OPEN_EXISTING
               , FILE_FLAG_OVERLAPPED
               ,0
               );

    // If we have a handle
    if hComm <>  INVALID_HANDLE_VALUE Then
    begin
        // set up com port properties, previously sorted out by a call
        // to the ports property page dialogue
        SetCommConfig(hComm, CommConfig, sizeof(CommConfig));

        // se the timeouts, so we don't hang around
        if  GetCommTimeouts(hComm, ComTimeOuts) then
        begin
                ComTimeOuts.ReadIntervalTimeout := 0;
                ComTimeOuts.ReadTotalTimeoutMultiplier := 0;
                ComTimeOuts.ReadTotalTimeoutConstant := 50;
                SetCommTimeOuts(hComm, ComTimeOuts);
        end;

        // initialise overlapped structures, byte counters etc
        InitComms();
        PanelRxStatus.caption := 'Bytes Rxed : 0';
        PanelTxStatus.caption := 'Bytes Txed : 0';
        PanelStatus.caption := 'Connected to ' + DevName;

        // ensure we will be able to transmit data
        Memo2.Lines.BeginUpdate();
        memo2.Clear();
        Memo2.Lines.EndUpdate();

        // switch on reciever
        Timer1.Enabled := true;
        InTimer := false;
        InPaste := false;
        extra := '';
        Result := true;
    end
    else
    begin
        // not connected, reset captions
        PanelRxStatus.caption := '';
        PanelTxStatus.caption := '';
        PanelStatus.caption := 'Not Connected';
        Result := False;
    end;

end;

//-------------------------------------------------------------------------
// IfConnecedDisConnect
//-------------------------------------------------------------------------
// Function
//     If we are engaged in a conversation, disconnect us
// Parameters
//    None
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
function TFormTerm.AreDisConnected:Boolean;
begin
   If hComm <> INVALID_HANDLE_VALUE Then
   begin
        If MessageDlg('Disconnect from ' + DevName, mtInformation, [mbYes, mbNo], 0) = mrYes Then
        begin
           Timer1.Enabled := False;
           FreeComms();
           Result := True;
        end
        else
           Result := False;
   end
   else
       Result := True;
end;

//-------------------------------------------------------------------------
// NewConnection1Click
//-------------------------------------------------------------------------
// Function
//     some one selected new connection from menu
//     validate com port
//     set comm prorties with vendor supplied dialog
//     connect to com port
// Parameters
//     Sender - mandatory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.NewConnection1Click(Sender: TObject);
var
   Connected : Boolean;
   ComName:string;
   ret : TModalResult;
begin
   If AreDisConnected() Then
   begin
       Connected := False;

       with TFormConnect.Create(Application) as TFormConnect do
       begin
          try
          ret := ShowModal;
          ComName := Combobox1.Text;
          finally
          free;
          end;
       end;

       if ret = MrOk Then
       begin
           // set up port properties, by calling proprty page dialogue
           if SetComProperties(ComName, CommConfig) then
           begin
               // open the port
               if Connect(ComName, CommConfig) Then Connected := True;
           end;
       end;

       // set up user buttons if sucessfull
       // or raise dialog if port not avaliable
       if Connected Then
       begin
          SetUI(itConnected);
       end
       else if ret = mrOk Then
       begin
          MessageDlg('Failed to connect to ' + ComName, mtInformation, [mbOK], 0);
          SetUI(itNotConnected);
       end;
   end;
end;

//-------------------------------------------------------------------------
// TBNewConnectionClick
//-------------------------------------------------------------------------
// Function
//     some one selected new connection from tool bar
//     Can chose from drop down or call a dialogue
//     connect to com port
// Parameters
//     Sender - mandatory (unused)
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.TBNewConnectionClick(Sender: TObject);
var
   ComName:string;
begin
   // Work out com port name
   // and if selection a valid name
   //
   With Sender as TMenuItem Do 
   begin
       // If we have a valid connection
       //
       case tag of
       // None selected - offer to dump current connection
       0: AreDisconnected();

       // Coms 1 to 8 are offered as menu items
       1,2,3,4,5,6,7,8:
       begin
           // get new comm port name
           ComName := 'COM'+inttostr(tag);
           // dump existing connection if active
           If AreDisconnected() Then
           begin
              // set up port properties, by calling proprty page dialogue
              if SetComProperties(ComName, CommConfig) then
              begin
                  // open port and set up buttons etc
                  if Connect(ComName, CommConfig) Then
                        SetUI(itConnected)
                  else
                  begin
                        MessageDlg('Failed to connect to ' + ComName, mtInformation, [mbOK], 0);
                        SetUI(itNotConnected);
                  end;
              end;
           end;
       end
       //
       // Other.. selected so
       // Call NewConnection dialogue
       else
          NewConnection1Click(Sender);
   end;
   end;
end;



//-------------------------------------------------------------------------
// Connect
//-------------------------------------------------------------------------
// Function
//     Connect to current com port
// Parameters
//     None
// Returns
//    None
// Coded
//    helen                          
//-------------------------------------------------------------------------
procedure TFormTerm.Connect1Click(Sender: TObject);
begin
    if Connect(DevName, CommConfig) Then
          SetUI(itConnected)
    else
    begin
          MessageDlg('Failed to connect to ' + DevName, mtInformation, [mbOK], 0);
          SetUI(itNotConnected);
    end;
end;


//-------------------------------------------------------------------------
// DisConnect
//-------------------------------------------------------------------------
// Function
//     Close the port and set up the port properties
// Parameters
//    ComName : Name of port
// Returns
//    None
// Coded
//    helen                            
//-------------------------------------------------------------------------
procedure TFormTerm.Disconnect1Click(Sender: TObject);
begin
     Timer1.Enabled := False;
     FreeComms();
end;


//-------------------------------------------------------------------------
// COMSSETUP
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// SetComProperties
//-------------------------------------------------------------------------
// Function
//    Determines if the com port is a valid com port
//    Raises property dialogue for it
// Parameters
//    ComName : Name of port
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
Function TFormTerm.SetComProperties(ComName:string; var CommConfig:tCommConfig):Boolean;
begin
   // Set CommConfig to defaults
   //
   FillChar(CommConfig, sizeof(CommConfig), 0);
   CommConfig.dwsize := sizeof(CommConfig);
   CommConfig.wVersion := 1;
   GetCommState(hComm, CommConfig.dcb);
   CommConfig.dwProviderSubType  := PST_RS232;
   CommConfig.dwProviderSize := 1;

   //
   // Raise property dialog for selected comm port
   //
   if CommConfigDialog(@ComName[1], Handle , CommConfig) Then

        Result := True
   else
        Result := False;
end;


//-------------------------------------------------------------------------
// Settings2
//-------------------------------------------------------------------------
// Function
//   Change com settings
//
// Parameters
//    Sender - mandatory
//    Kye    - Key pressed
// Returns
//    None
// Coded
//    helen                          
//-------------------------------------------------------------------------
procedure TFormTerm.Settings2Click(Sender: TObject);
begin
   if hComm <> INVALID_HANDLE_VALUE Then
   begin
        // change settings, disconnect and reconnect to kick coms
        FreeComms();
        SetComProperties(DevName, CommConfig);
        if Connect(DevName, CommConfig) Then
              SetUI(itConnected)
        else
        begin
              MessageDlg('Failed to connect to ' + DevName, mtInformation, [mbOK], 0);
              SetUI(itNotConnected);
        end;
   end
   else
   begin
        SetComProperties(DevName, CommConfig);
   end
end;


//-------------------------------------------------------------------------
// TRANSMITTING / RECIEVING
//-------------------------------------------------------------------------

//-------------------------------------------------------------------------
// FormKeyPress
//-------------------------------------------------------------------------
// Function
//   If conncted to com port, write this char to it
//
// Parameters
//    Sender - mandatory
//    Kye    - Key pressed
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.FormKeyPress(Sender: TObject; var Key: Char);
begin
     // if the port isn't open, forget it
     if hComm = INVALID_HANDLE_VALUE  Then exit;

     // if we trying to stuff keys into memo, the queue up the extra until we finish
     if InPaste Then
     begin
        extra := extra + key;
        exit;
     end;
     InPaste := True;

     // add the key pressed to the end of the outgoing text
     // the timer will deal with transmitting it
     Memo2.Lines.BeginUpdate();
     if memo2.lines.count > 0 then
        Memo2.Lines[memo2.lines.count-1] := Memo2.Lines[memo2.lines.count-1] + extra + key
     else
        memo2.lines.add(extra+key);

     extra := '';
     Memo2.Lines.EndUpdate();
     InPaste := False;
end;

//-------------------------------------------------------------------------
// Send Text File
//-------------------------------------------------------------------------
// Function
//   Dumps a text file into out going buffer
//
// Parameters
//    Sender - mandatory
//    Kye    - Key pressed
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.SendTextFile1Click(Sender: TObject);
begin
   // find file to open
   if OpenDialog1.execute then
   begin
     SendTextFile1.Enabled := false;
     InPaste := true;
     // stuff file contents into memo2
     // timer deals with transmitting it
     memo2.Lines.beginUpdate();
     memo2.Lines.LoadFromFile(Opendialog1.FileName);
     memo2.Lines.EndUpdate();
     InPaste := false;
   end;
end;

//-------------------------------------------------------------------------
// UpdateMemo
//-------------------------------------------------------------------------
// Function
//    Interperit incoming text as simple telnet terminal
// Parameters
//    Sender - mandatory
//    Kye    - Key pressed
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.UpdateMemo(a : array of char; l : cardinal);
var
  c:char;
  s2:string;
  i:integer;
  sl:TstringList;
begin
   FormTerm.BytesRxed := FormTerm.BytesRxed + l;

   // fetch last line from memo box
   Memo1.Lines.BeginUpdate();
   If Memo1.Lines.Count > 0 then
      s2 := Memo1.Lines[Memo1.lines.count-1]
   else
      s2 := '';
   // create a temporary string list to work in
   SL := TStringList.Create;

   for i := 0 to l-1 do
   begin
      c := a[i];
      // If <LF> add a new line
      if c = #13 then
      begin
          SL.Add(s2);
          s2 := '';
          p := 1;
      end
      // if <CR> reset position to start of current line
      else if c = #10 then
      begin
         p := 1;
      end
      // if <BS> delete appropriate character
      else if c = #8 then
      begin
         if p > 1 then
         begin
           dec(p);
           delete(s2,p,1);
         end;
      end
      // if <DLE> delete
      else if c = #16 then
      begin
         if p > 1 then
         begin
           delete(s2,p,1);
           dec(p);
         end;
      end
      // if a valid character add it to the text
      else if c in [' '..'~', chr(9)] then
      begin
          if p < length(s2) Then
               insert(c, s2, p)
          else
               s2 := s2 + c;
          inc(p);
      end;
   end;
   SL.Add(s2);
   application.processmessages();

   // if the memo has text in it, change the last line
   If Memo1.Lines.Count > 0 then
   begin
      memo1.Lines[Memo1.Lines.Count-1] :=  SL.Strings[0];
      SL.Delete(0);
   end;

   // add remaining strings to memo
   memo1.Lines.AddStrings(SL);
   Memo1.Lines.EndUpdate();
   // throw away tempory string list
   SL.Free;

   // move memo to bottom
   Memo1.SetFocus;
   Memo1.selstart := length(memo1.Text)-1;

   // update number of bytes recieved
   PanelRxStatus.caption := 'Bytes Rxed :' + inttostr(FormTerm.BytesRxed);
   PanelRxStatus.refresh;

end;

//-------------------------------------------------------------------------
// Timer1Timer
//-------------------------------------------------------------------------
// Function
//     unload recieved chars into display
//     puump data into txmitter
// Parameters
//    None
// Returns
//    None
// Coded
//    helen
//-------------------------------------------------------------------------
procedure TFormTerm.Timer1Timer(Sender: TObject);
const
   ARBSIZE = 32;
var
    Ret:Boolean;
    BytesRead:cardinal;
    s:string;
    BytesWritten:cardinal;
    dwRet, l:cardinal;
    err:integer;
begin
    if hComm = INVALID_HANDLE_VALUE Then exit;

    // check re-entrancy
    if InTimer Then exit;
    InTimer := true;

    Timer1.Enabled := False;

    // deal with recieve data

    // if we are waiting for a previous read to complete
    if fWaitingRx Then
    begin
        // see if its done
        dwRet := WaitForSingleObject(osRx.hEvent, 10);

        if dwRet = WAIT_OBJECT_0 then
        begin
          if GetOverlappedResult(hComm, osRx, BytesRead, FALSE) Then
          begin
              // read the incoming characters and update the display
              if (BytesRead > 0) Then UpdateMemo(Rxbuffer, BytesRead);
              // flag we are no longer waiting
              fWaitingRx := False;
          end
       end
    end;

    if Not fWaitingRx Then
    begin
        // wait for imcoming coms
        Ret := ReadFile( hComm, RxBuffer, 1024, BytesRead, @osRx);

        // if we get some data update the display
        if Ret and (bytesRead > 0) Then
        begin
            UpdateMemo(Rxbuffer, BytesRead);
        end
        else
        begin
            err := getLastError;

            if err = ERROR_IO_PENDING Then
            begin
                // flag we are waiting for coms for the next time round
                fWaitingRX := True;
            end;
        end;
    end;

    // deal with transmit data

    // if we are already transmitting
    if fTxing Then
    begin
        // wait for the previous lot of data send to able off
        dwRet := WaitForSingleObject(osTx.hEvent, 10);

        if dwRet = WAIT_OBJECT_0 then
        begin
          if GetOverlappedResult(hComm, osTx, BytesWritten, FALSE) Then
          begin
              // we sent this data, add it to bytes sent
              BytesTxed := BytesTxed  + bytesWritten;
              PanelTxStatus.caption := 'Bytes Txed : ' + inttostr(BytesTxed);
              // we can now send more
              fTxing := false;
          end;
        end;
    end;

    // if we aren't txmitting and there is data to send and its not changing
    if (Not fTxing) and (Memo2.lines.Count > 0) and (not InPaste) then
    begin
         // get the next line of info to go out of the buffer
         // if theres only one line left don't send a CR LF
         if memo2.lines.count > 1 Then
            s :=  Memo2.Lines[0] + #10 + #13
         else
            s :=  Memo2.Lines[0];

         // copy the line (or 1024 bytes) out to the com port
         strplcopy(txbuffer, s, 1024);

         if length(s) <= 1024 then
            l := length(s)
         else
            l := 1024;

         // send the line over the coms port
         Ret := writeFile(hComm, txbuffer, l, BytesWritten, @osTx);
         // remove the line we've done with it
         Memo2.Lines.Delete(0);

         If Ret then
         begin
            // if we managed to send the data then update the
            // bytes transmitted and leave the ftxing falg clear
            BytesTxed := BytesTxed  + bytesWritten;
            PanelTxStatus.caption := 'Bytes Txed : ' + inttostr(BytesTxed);
         end
         else
         begin
            // if we are waiting for IO to complete then falg this
            // and we'll check if its done on the next timer
            err := getLastError;
            if err = ERROR_IO_PENDING Then fTxing := true;
         end;
    end;

    // If the outgoing memo box is empty, allow the user to send a file
    if (Memo2.Lines.Count = 0) and not fTxing Then
    begin
        SendTextFile1.Enabled := true;
    end;

    // clear the re-entrancy flag
    InTimer := False;
    Timer1.Enabled := true;

end;


//-------------------------------------------------------------------------
// Editing
//-------------------------------------------------------------------------

procedure TFormTerm.Copy1Click(Sender: TObject);
begin
   try
   if (memo1.lines.count > 0) and (Memo1.SelLength > 0) then  memo1.CopyToClipBoard;
   finally
   end;
end;

procedure TFormTerm.SelectAll1Click(Sender: TObject);
begin
     try
     Memo1.SelectAll;
     finally
     end;
end;

procedure TFormTerm.Paste1Click(Sender: TObject);
begin
   // paste the clipboard into memo2 and the timer transmits it
   if InPaste Then exit;
   InPaste := True;
   Memo2.Lines.BeginUpdate();
   Memo2.PastefromClipBoard;
   Memo2.Lines.EndUpdate();
   InPaste := false;
end;


procedure TFormTerm.ClearBuffer1Click(Sender: TObject);
begin
  Memo1.Lines.Clear;
  p := 1;
end;


procedure TFormTerm.ViewTextFile1Click(Sender: TObject);
begin
   if OpenDialog1.execute then
   begin
     memo1.Lines.LoadFromFile(Opendialog1.FileName);
     p := 1;

   end;
end;

//-------------------------------------------------------------------------
// Print
//-------------------------------------------------------------------------
procedure TFormTerm.Print1Click(Sender: TObject);
begin
     If PrintDialog1.Execute Then Memo1.Print('Captured from ' + StrPas(DevName));
end;

//-------------------------------------------------------------------------
// Save to file
//-------------------------------------------------------------------------
procedure TFormTerm.S1Click(Sender: TObject);
begin
     If SaveDialog1.Execute Then
     begin
          Memo1.Lines.SaveToFile( SaveDialog1.FileName);
     end;
end;

//-------------------------------------------------------------------------
// Formating
//-------------------------------------------------------------------------
procedure TFormTerm.Font1Click(Sender: TObject);
begin
    if FontDialog1.execute() Then
       Memo1.Font := FontDialog1.Font;
end;

//-------------------------------------------------------------------------
// Help
//-------------------------------------------------------------------------
procedure TFormTerm.AboutMEVTerminal1Click(Sender: TObject);
begin
     FormAbout.ShowModal();
end;




end.

